/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DefaultConsumerBridgeErrorHandlerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultConsumerBridgeErrorHandlerRedeliveryTest
extends DefaultConsumerBridgeErrorHandlerTest {
    protected final AtomicInteger redeliverCounter = new AtomicInteger();

    @Override
    @Test
    public void testDefaultConsumerBridgeErrorHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Cannot process"});
        this.latch.countDown();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)this.redeliverCounter.get());
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Simulated", (Object)cause.getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().addComponent("my", (Component)new DefaultConsumerBridgeErrorHandlerTest.MyComponent(DefaultConsumerBridgeErrorHandlerRedeliveryTest.this));
                this.onException(Exception.class).maximumRedeliveries(3).onRedelivery(new Processor(){

                    public void process(Exchange exchange) {
                        DefaultConsumerBridgeErrorHandlerRedeliveryTest.this.redeliverCounter.incrementAndGet();
                    }
                }).redeliveryDelay(0L).handled(true).to("mock:dead");
                ((RouteDefinition)this.from("my:foo?bridgeErrorHandler=true").to("log:foo")).to("mock:result");
            }
        };
    }
}

