/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelUseOriginalInBodyWithFileTest
extends ContextTestSupport {
    @Test
    public void testOriginalInBodyIsFile() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        dead.expectedMessageCount(1);
        ((MockValueBuilder)dead.message(0).body()).isInstanceOf(GenericFile.class);
        ((MockValueBuilder)dead.message(0).body(String.class)).isEqualTo((Object)"Hello");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").disableRedelivery().logStackTrace(false).useOriginalMessage());
                ((RouteDefinition)this.from(DeadLetterChannelUseOriginalInBodyWithFileTest.this.fileUri("?initialDelay=0&delay=10&noop=true")).transform((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor());
            }
        };
    }

    public static class MyThrowProcessor
    implements Processor {
        public void process(Exchange exchange) {
            Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody(String.class));
            throw new IllegalArgumentException("Forced");
        }
    }
}

