/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint deadEndpoint;
    protected MockEndpoint successEndpoint;
    protected int failUntilAttempt = 2;
    protected final String body = "<hello>world!</hello>";

    @Test
    public void testFirstFewAttemptsFail() throws Exception {
        this.successEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        ((MockValueBuilder)this.successEndpoint.message(0).header("CamelRedelivered")).isEqualTo((Object)true);
        ((MockValueBuilder)this.successEndpoint.message(0).header("CamelRedeliveryCounter")).isEqualTo((Object)1);
        ((MockValueBuilder)this.successEndpoint.message(0).header("CamelRedeliveryMaxCounter")).isEqualTo((Object)2);
        this.deadEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", "<hello>world!</hello>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLotsOfAttemptsFail() throws Exception {
        this.failUntilAttempt = 5;
        this.deadEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedelivered")).isNull();
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedeliveryCounter")).isNull();
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedeliveryMaxCounter")).isNull();
        this.successEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", "<hello>world!</hello>");
        this.assertMockEndpointsSatisfied();
        Throwable t = (Throwable)((Exchange)this.deadEndpoint.getExchanges().get(0)).getProperty("CamelExceptionCaught", Throwable.class);
        Assertions.assertNotNull((Object)t, (String)"Should have been a cause property");
        boolean b = t instanceof RuntimeException;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"Failed to process due to attempt: 3 being less than: 5", (Object)t.getMessage());
        Exchange dead = (Exchange)this.deadEndpoint.getReceivedExchanges().get(0);
        Assertions.assertEquals((Object)ExchangePattern.InOnly, (Object)dead.getPattern());
    }

    @Test
    public void testLotsOfAttemptsFailInOut() throws Exception {
        this.failUntilAttempt = 5;
        this.deadEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedelivered")).isNull();
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedeliveryCounter")).isNull();
        ((MockValueBuilder)this.deadEndpoint.message(0).header("CamelRedeliveryMaxCounter")).isNull();
        this.successEndpoint.expectedMessageCount(0);
        this.template.requestBody("direct:start", (Object)"<hello>world!</hello>");
        this.assertMockEndpointsSatisfied();
        Throwable t = (Throwable)((Exchange)this.deadEndpoint.getExchanges().get(0)).getProperty("CamelExceptionCaught", Throwable.class);
        Assertions.assertNotNull((Object)t, (String)"Should have been a cause property");
        boolean b = t instanceof RuntimeException;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"Failed to process due to attempt: 3 being less than: 5", (Object)t.getMessage());
        Exchange dead = (Exchange)this.deadEndpoint.getReceivedExchanges().get(0);
        Assertions.assertEquals((Object)ExchangePattern.InOnly, (Object)dead.getPattern());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.deadEndpoint = this.getMockEndpoint("mock:failed");
        this.successEndpoint = this.getMockEndpoint("mock:success");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                int attempt;
                Integer counter = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
                int n = attempt = counter == null ? 1 : counter + 1;
                if (attempt < DeadLetterChannelTest.this.failUntilAttempt) {
                    throw new RuntimeException("Failed to process due to attempt: " + attempt + " being less than: " + DeadLetterChannelTest.this.failUntilAttempt);
                }
            }
        };
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:failed").maximumRedeliveries(2).redeliveryDelay(50L).loggingLevel(LoggingLevel.DEBUG)).process(processor)).to("mock:success");
            }
        };
    }
}

