/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelRedeliveryTest
extends ContextTestSupport {
    private static int counter;
    private static int redeliveryCounter;

    @Test
    public void testTwoRedeliveryTest() throws Exception {
        counter = 0;
        redeliveryCounter = 0;
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:two", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)counter);
        Assertions.assertEquals((int)2, (int)redeliveryCounter);
    }

    @Test
    public void testNoRedeliveriesTest() throws Exception {
        counter = 0;
        redeliveryCounter = 0;
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:no", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)counter);
        Assertions.assertEquals((int)0, (int)redeliveryCounter);
    }

    @Test
    public void testOneRedeliveriesTest() throws Exception {
        counter = 0;
        redeliveryCounter = 0;
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:one", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)counter);
        Assertions.assertEquals((int)1, (int)redeliveryCounter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.bindToRegistry("redeliveryProcessor", exchange -> {
                    redeliveryCounter = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
                });
                this.from("direct:two").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(0L).onRedeliveryRef("redeliveryProcessor")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:no").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(0).onRedeliveryRef("redeliveryProcessor")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:one").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(1).redeliveryDelay(0L).onRedeliveryRef("redeliveryProcessor")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        };
    }
}

