/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelRedeliveryDelayPatternTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testDelayPatternTest() throws Exception {
        counter = 0;
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        StopWatch watch = new StopWatch();
        this.template.sendBody("direct:start", (Object)"Hello World");
        long delta = watch.taken();
        Assertions.assertTrue((delta > 1000L ? 1 : 0) != 0, (String)"Should be slower");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").delayPattern("0:250;2:500").maximumRedeliveries(3).onRedelivery(new Processor(){

                    public void process(Exchange exchange) {
                        ++counter;
                    }
                }));
                this.from("direct:start").throwException(new Exception("Forced exception by unit test"));
            }
        };
    }
}

