/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelRedeliveringWhileShutdownTest
extends ContextTestSupport {
    @Test
    public void testDLCRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:damm", (Object)"Damn World");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(3).redeliveryDelay(100L));
                this.from("direct:start").to("mock:result");
                this.from("seda:damm").process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Damn");
                    }
                });
            }
        };
    }
}

