/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelPropagateCausedExceptionTest
extends ContextTestSupport {
    @Test
    public void testDLCPropagateCaused() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:start").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        DeadLetterChannelPropagateCausedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
    }

    @Test
    public void testDLCPropagateCausedInRoute() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dead"));
                ((RouteDefinition)this.from("direct:dead").to("log:dead")).to("mock:dead");
                ((RouteDefinition)this.from("direct:start").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        DeadLetterChannelPropagateCausedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
    }

    @Test
    public void testDLCPropagateCausedUseOriginalMessage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").useOriginalMessage());
                ((RouteDefinition)this.from("direct:start").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        DeadLetterChannelPropagateCausedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
    }

    @Test
    public void testDLCPropagateCausedInRouteUseOriginalMessage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dead").useOriginalMessage());
                ((RouteDefinition)this.from("direct:dead").to("log:dead")).to("mock:dead");
                ((RouteDefinition)this.from("direct:start").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        DeadLetterChannelPropagateCausedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
    }

    @Test
    public void testDLCPropagateCausedInSplitter() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:a")).split((Expression)this.body().tokenize(",")).stopOnException().process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Damn");
                        }
                    }
                })).to("mock:line");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A,B,C,Kaboom");
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        DeadLetterChannelPropagateCausedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
    }
}

