/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelOnRedeliveryTest
extends ContextTestSupport {
    static int counter;

    @Test
    public void testOnExceptionAlterMessageBeforeRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionAlterMessageWithHeadersBeforeRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        mock.expectedHeaderReceived("foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        counter = 0;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(5).onRedelivery((Processor)new MyRedeliverProcessor()).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").process(new Processor(){

                    public void process(Exchange exchange) {
                        if (++counter <= 3) {
                            throw new IllegalArgumentException("Forced by unit test");
                        }
                    }
                })).to("mock:result");
            }
        };
    }

    public static class MyRedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            int count = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
            exchange.getIn().setBody((Object)(body + count));
            int max = (Integer)exchange.getIn().getHeader("CamelRedeliveryMaxCounter", Integer.class);
            Assertions.assertEquals((int)5, (int)max);
            String rid = (String)exchange.getProperty("CamelFailureRouteId", String.class);
            Assertions.assertEquals((Object)"myRoute", (Object)rid);
        }
    }
}

