/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testDeadLetterChannelOnPrepare() throws Exception {
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:dead").expectedHeaderReceived("FailedBecause", (Object)"Forced");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").onPrepareFailure((Processor)new MyPrepareProcessor()));
                ((RouteDefinition)this.from("direct:start").log("Incoming ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyPrepareProcessor
    implements Processor {
        public void process(Exchange exchange) {
            Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
            exchange.getIn().setHeader("FailedBecause", (Object)cause.getMessage());
        }
    }
}

