/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelOnExceptionOnRedeliveryTest
extends ContextTestSupport {
    static int counter;

    @Test
    public void testGlobalOnRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteSpecificOnRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)mock.message(0).header("Timeout")).isEqualTo((Object)5000);
        this.template.sendBody("direct:io", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        counter = 0;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IOException.class).maximumRedeliveries(3).redeliveryDelay(0L).onRedelivery((Processor)new MyIORedeliverProcessor());
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(5).onRedelivery((Processor)new MyRedeliverProcessor()).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:start").process((Processor)new ThrowExceptionProcessor())).to("mock:result");
                ((RouteDefinition)this.from("direct:io").process((Processor)new ThrowIOExceptionProcessor())).to("mock:result");
            }
        };
    }

    public static class ThrowIOExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (++counter <= 3) {
                throw new IOException("Cannot connect");
            }
        }
    }

    public static class ThrowExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) {
            if (++counter <= 3) {
                throw new IllegalArgumentException("Forced by unit test");
            }
        }
    }

    public static class MyIORedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getIn().setHeader("Timeout", (Object)5000);
        }
    }

    public static class MyRedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            int count = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
            exchange.getIn().setBody((Object)(body + count));
        }
    }
}

