/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelNoRedeliveryTest
extends ContextTestSupport {
    private static final LongAdder counter = new LongAdder();

    @Test
    public void testDLCNoRedelivery() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)counter.intValue(), (String)"Only the original attempt");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(0));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).process((Processor)new MyFailProcessor())).to("mock:b");
            }
        };
    }

    public static final class MyFailProcessor
    implements Processor {
        public void process(Exchange exchange) {
            counter.increment();
            throw new IllegalArgumentException("Forced");
        }
    }
}

