/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Headers;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelHandledExampleTest
extends ContextTestSupport {
    @Test
    public void testOrderOK() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Order OK"});
        result.expectedHeaderReceived("orderid", (Object)"123");
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: MacBook Pro", "customerid", (Object)"444");
        Assertions.assertEquals((Object)"Order OK", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOrderERROR() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"Order ERROR"});
        error.expectedHeaderReceived("orderid", (Object)"failed");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: kaboom", "customerid", (Object)"555");
        Assertions.assertEquals((Object)"Order ERROR", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(OrderFailedException.class).handled(true).bean(OrderService.class, "orderFailed")).to("mock:error");
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(1));
                ((RouteDefinition)this.from("direct:start").bean(OrderService.class, "handleOrder")).to("mock:result");
            }
        };
    }

    public static class OrderFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public OrderFailedException(String message) {
            super(message);
        }
    }

    public static class OrderService {
        public Object handleOrder(@Headers Map headers, @Body String payload) throws OrderFailedException {
            headers.put("customerid", headers.get("customerid"));
            if ("Order: kaboom".equals(payload)) {
                throw new OrderFailedException("Cannot order: kaboom");
            }
            headers.put("orderid", "123");
            return "Order OK";
        }

        public Object orderFailed(@Headers Map headers, @Body String payload) {
            headers.put("customerid", headers.get("customerid"));
            headers.put("orderid", "failed");
            return "Order ERROR";
        }
    }
}

