/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelFailureRouteIdTest
extends ContextTestSupport {
    @Test
    public void testFailureRouteId() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        dead.expectedMessageCount(1);
        dead.expectedPropertyReceived("CamelFailureRouteId", (Object)"bar");
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dead"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:foo")).to("direct:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:bar")).throwException((Exception)new IllegalArgumentException("Forced"));
                ((RouteDefinition)this.from("direct:dead").log("Failed at route ${exchangeProperty.CamelFailureRouteId}")).to("mock:dead");
            }
        };
    }
}

