/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeadLetterChannelAlwaysHandledTest
extends ContextTestSupport {
    private static final AtomicBoolean CALLLED = new AtomicBoolean();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myHandler", (Object)new MyExceptionHandler());
        return jndi;
    }

    @Test
    public void testDeadLetterChannelAlwaysHandled() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)CALLLED.get(), (String)"Should not have called");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo?exceptionHandler=#myHandler").routeId("foo").to("mock:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").routeId("bar").onException(IllegalArgumentException.class).maximumRedeliveries(3).redeliveryDelay(0L).end().to("mock:bar").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    private static final class MyExceptionHandler
    implements ExceptionHandler {
        private MyExceptionHandler() {
        }

        public void handleException(Throwable exception) {
            CALLLED.set(true);
        }

        public void handleException(String message, Throwable exception) {
            CALLLED.set(true);
        }

        public void handleException(String message, Exchange exchange, Throwable exception) {
            CALLLED.set(true);
        }
    }
}

