/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataFormatServiceTest
extends ContextTestSupport {
    protected final MyDataFormat my = new MyDataFormat();

    @Test
    public void testMarshal() throws Exception {
        Assertions.assertTrue((boolean)this.my.isStarted());
        Assertions.assertSame((Object)this.context, (Object)this.my.getCamelContext());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hi Camel"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((boolean)this.my.isStopped());
        Assertions.assertSame((Object)this.context, (Object)this.my.getCamelContext());
    }

    @Test
    public void testUnmarshal() throws Exception {
        Assertions.assertTrue((boolean)this.my.isStarted());
        Assertions.assertSame((Object)this.context, (Object)this.my.getCamelContext());
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((boolean)this.my.isStopped());
        Assertions.assertSame((Object)this.context, (Object)this.my.getCamelContext());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").marshal((DataFormat)DataFormatServiceTest.this.my)).to("mock:a");
                ((RouteDefinition)this.from("direct:b").unmarshal((DataFormat)DataFormatServiceTest.this.my)).to("mock:b");
            }
        };
    }

    public static class MyDataFormat
    extends ServiceSupport
    implements DataFormat,
    CamelContextAware {
        private CamelContext camelContext;

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
            stream.write("Hi Camel".getBytes());
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            return "Bye World";
        }
    }
}

