/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Test;

public class CustomScheduledRoutePolicyTest
extends ContextTestSupport {
    private final MyCustomRoutePolicy policy = new MyCustomRoutePolicy();

    @Test
    public void testCustomPolicy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.setResultWaitTime(2000L);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        mock.assertIsNotSatisfied();
        this.policy.startRoute();
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").autoStartup(false).routePolicy(new RoutePolicy[]{CustomScheduledRoutePolicyTest.this.policy}).to("mock:result");
            }
        };
    }

    private static class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private Route route;

        private MyCustomRoutePolicy() {
        }

        public void onInit(Route route) {
            this.route = route;
        }

        public void startRoute() throws Exception {
            this.startRoute(this.route);
        }
    }
}

