/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomRoutePolicyDirectTest
extends ContextTestSupport {
    private final MyCustomRoutePolicy policy = new MyCustomRoutePolicy();

    @Test
    public void testCustomPolicy() throws Exception {
        Assertions.assertEquals((int)0, (int)this.policy.getInflight1());
        Assertions.assertEquals((int)0, (int)this.policy.getInflight2());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)this.policy.getInflight1());
        Assertions.assertEquals((int)0, (int)this.policy.getInflight2());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").routePolicy(new RoutePolicy[]{CustomRoutePolicyDirectTest.this.policy}).process(e -> {
                    Assertions.assertEquals((int)1, (int)CustomRoutePolicyDirectTest.this.policy.getInflight1());
                    Assertions.assertEquals((int)0, (int)CustomRoutePolicyDirectTest.this.policy.getInflight2());
                })).to("direct:bar")).process(e -> {
                    Assertions.assertEquals((int)1, (int)CustomRoutePolicyDirectTest.this.policy.getInflight1());
                    Assertions.assertEquals((int)0, (int)CustomRoutePolicyDirectTest.this.policy.getInflight2());
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").routePolicy(new RoutePolicy[]{CustomRoutePolicyDirectTest.this.policy}).process(e -> {
                    Assertions.assertEquals((int)1, (int)CustomRoutePolicyDirectTest.this.policy.getInflight1());
                    Assertions.assertEquals((int)1, (int)CustomRoutePolicyDirectTest.this.policy.getInflight2());
                })).to("mock:b");
            }
        };
    }

    private static class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private volatile int inflight1;
        private volatile int inflight2;

        private MyCustomRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            if ("foo".equals(route.getId())) {
                ++this.inflight1;
            } else {
                ++this.inflight2;
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            if ("foo".equals(route.getId())) {
                --this.inflight1;
            } else {
                --this.inflight2;
            }
        }

        public int getInflight1() {
            return this.inflight1;
        }

        public int getInflight2() {
            return this.inflight2;
        }
    }
}

