/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CustomLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance((LoadBalancer)new MyLoadBalancer()).to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        };
    }

    @Test
    public void testCustomLoadBalancer() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"x", "x", "x"});
        this.y.expectedBodiesReceived(new Object[]{"y", "y"});
        this.z.expectedBodiesReceived(new Object[]{"foo", "bar", "baz"});
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"y");
        this.template.sendBody("direct:start", (Object)"foo");
        this.template.sendBody("direct:start", (Object)"bar");
        this.template.sendBody("direct:start", (Object)"y");
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"baz");
        this.assertMockEndpointsSatisfied();
    }

    public static class MyLoadBalancer
    extends LoadBalancerSupport {
        public boolean process(Exchange exchange, AsyncCallback callback) {
            String body = (String)exchange.getIn().getBody(String.class);
            try {
                if ("x".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(0)).process(exchange);
                } else if ("y".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(1)).process(exchange);
                } else {
                    ((AsyncProcessor)this.getProcessors().get(2)).process(exchange);
                }
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
    }
}

