/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Test;

public class ConsumerRouteIdAwareTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ConsumerRouteIdAwareTest.this.context.addComponent("my", (Component)new MyComponent((CamelContext)ConsumerRouteIdAwareTest.this.context));
                this.from("my:foo").routeId("foo").to("mock:result");
            }
        };
    }

    @Test
    public void testRouteIdAware() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello from consumer route foo"});
        this.assertMockEndpointsSatisfied();
    }

    private static class MyConsumer
    extends DefaultConsumer {
        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() throws Exception {
            super.doStart();
            Runnable run = () -> {
                Exchange exchange = this.getEndpoint().createExchange();
                exchange.getMessage().setBody((Object)("Hello from consumer route " + this.getRouteId()));
                try {
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
            };
            Thread t = new Thread(run);
            t.start();
        }
    }

    private static class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() {
            throw new UnsupportedOperationException("Not supported");
        }

        public Consumer createConsumer(Processor processor) {
            return new MyConsumer((Endpoint)this, processor);
        }
    }

    private static class MyComponent
    extends DefaultComponent {
        public MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyEndpoint(uri, (Component)this);
        }
    }
}

