/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComposedMessageProcessorTest
extends ContextTestSupport {
    @Test
    public void testValidatingCorrectOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedHeaderReceived("orderId", (Object)"myorderid");
        List<OrderItem> order = Arrays.asList(new OrderItem("widget", 5), new OrderItem("gadget", 10));
        this.template.sendBodyAndHeader("direct:start", order, "orderId", (Object)"myorderid");
        this.assertMockEndpointsSatisfied();
        List validatedOrder = (List)((Exchange)resultEndpoint.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertTrue((boolean)((OrderItem)validatedOrder.get((int)0)).valid);
        Assertions.assertTrue((boolean)((OrderItem)validatedOrder.get((int)1)).valid);
    }

    @Test
    public void testValidatingIncorrectOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedHeaderReceived("orderId", (Object)"myorderid");
        List<OrderItem> order = Arrays.asList(new OrderItem("widget", 500), new OrderItem("gadget", 200));
        this.template.sendBodyAndHeader("direct:start", order, "orderId", (Object)"myorderid");
        this.assertMockEndpointsSatisfied();
        List validatedOrder = (List)((Exchange)resultEndpoint.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertFalse((boolean)((OrderItem)validatedOrder.get((int)0)).valid);
        Assertions.assertFalse((boolean)((OrderItem)validatedOrder.get((int)1)).valid);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("orderItemHelper", (Object)new OrderItemHelper());
        jndi.bind("widgetInventory", (Object)new WidgetInventory());
        jndi.bind("gadgetInventory", (Object)new GadgetInventory());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((SplitDefinition)this.from("direct:start").split().body()).choice().when().method("orderItemHelper", "isWidget")).to("bean:widgetInventory")).otherwise().to("bean:gadgetInventory")).end().to("seda:aggregate");
                ((AggregateDefinition)this.from("seda:aggregate").aggregate((AggregationStrategy)new MyOrderAggregationStrategy()).header("orderId")).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:result");
            }
        };
    }

    public static final class OrderItem {
        final String type;
        final int quantity;
        boolean valid;

        public OrderItem(String type, int quantity) {
            this.type = type;
            this.quantity = quantity;
        }
    }

    public static final class OrderItemHelper {
        private OrderItemHelper() {
        }

        public static boolean isWidget(@Body OrderItem orderItem) {
            return orderItem.type.equals("widget");
        }
    }

    public static final class WidgetInventory {
        public void checkInventory(@Body OrderItem orderItem) {
            Assertions.assertEquals((Object)"widget", (Object)orderItem.type);
            if (orderItem.quantity < 10) {
                orderItem.valid = true;
            }
        }
    }

    public static final class GadgetInventory {
        public void checkInventory(@Body OrderItem orderItem) {
            Assertions.assertEquals((Object)"gadget", (Object)orderItem.type);
            if (orderItem.quantity < 20) {
                orderItem.valid = true;
            }
        }
    }

    public static final class MyOrderAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            ArrayList<OrderItem> order = new ArrayList<OrderItem>(2);
            order.add((OrderItem)oldExchange.getIn().getBody(OrderItem.class));
            order.add((OrderItem)newExchange.getIn().getBody(OrderItem.class));
            oldExchange.getIn().setBody(order);
            return oldExchange;
        }
    }
}

