/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.language.xpath.XPath;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class ClaimCheckTest
extends ContextTestSupport {
    public static final Map<String, Object> dataStore = new HashMap<String, Object>();

    @Test
    public void testClaimCheck() throws Exception {
        String body = "<order custId=\"123\"><lotsOfContent/></order>";
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        ((MockValueBuilder)resultEndpoint.message(0).body()).isEqualTo((Object)body);
        MockEndpoint testCheckpointEndpoint = this.getMockEndpoint("mock:testCheckpoint");
        testCheckpointEndpoint.expectedMessageCount(1);
        testCheckpointEndpoint.expectedHeaderReceived("claimCheck", (Object)"123");
        ((MockValueBuilder)testCheckpointEndpoint.message(0).body()).isNull();
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("checkLuggage", (Object)new CheckLuggageBean());
        jndi.bind("dataEnricher", (Object)new DataEnricherBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"bean:checkLuggage", "mock:testCheckpoint", "bean:dataEnricher", "mock:result"});
            }
        };
    }

    public static final class CheckLuggageBean {
        public void checkLuggage(Exchange exchange, @Body String body, @XPath(value="/order/@custId") String custId) {
            dataStore.put(custId, body);
            exchange.getIn().setHeader("claimCheck", (Object)custId);
            exchange.getIn().setBody(null);
        }
    }

    public static final class DataEnricherBean {
        public void addDataBackIn(Exchange exchange, @Header(value="claimCheck") String claimCheck) {
            exchange.getIn().setBody(dataStore.get(claimCheck));
            dataStore.remove(claimCheck);
            exchange.getIn().removeHeader("claimCheck");
        }
    }
}

