/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ClaimCheckEipPushPopHeadersPatternTest
extends ContextTestSupport {
    @Test
    public void testPushPopHeadersPattern() throws Exception {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("bar", "Moes");
        headers.put("car", "Toyota");
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedHeaderReceived("foo", (Object)123);
        this.getMockEndpoint("mock:a").expectedHeaderReceived("bar", (Object)"Moes");
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).header("car")).isEqualTo((Object)"Toyota");
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:b").expectedHeaderReceived("foo", (Object)456);
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).header("bar")).isNull();
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).header("car")).isEqualTo((Object)"Toyota");
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:c").expectedHeaderReceived("foo", (Object)123);
        this.getMockEndpoint("mock:c").expectedHeaderReceived("bar", (Object)"Moes");
        ((MockValueBuilder)this.getMockEndpoint("mock:c").message(0).header("car")).isEqualTo((Object)"Toyota");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).claimCheck(ClaimCheckOperation.Push)).transform().constant((Object)"Bye World")).setHeader("foo", (Expression)this.constant(456))).removeHeader("bar")).to("mock:b")).claimCheck(ClaimCheckOperation.Pop, null, "header:(foo|bar)")).to("mock:c");
            }
        };
    }
}

