/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChoicePredicateThrowExceptionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testChoiceGlobal() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(e -> {
                    throw new IllegalArgumentException("Forced");
                }).to("mock:a")).to("mock:b")).to("mock:c")).otherwise().to("mock:d")).to("mock:e")).to("mock:f")).end().end().to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:e").expectedMessageCount(0);
        this.getMockEndpoint("mock:f").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail();
        }
        catch (Exception e) {
            ChoicePredicateThrowExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testChoiceSubRoute() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("direct:sub")).to("mock:result");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:sub").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).choice().when(e -> {
                    throw new IllegalArgumentException("Forced");
                }).to("mock:a")).to("mock:b")).to("mock:c")).otherwise().to("mock:d")).to("mock:e")).to("mock:f")).end();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:e").expectedMessageCount(0);
        this.getMockEndpoint("mock:f").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail();
        }
        catch (Exception e) {
            ChoicePredicateThrowExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

