/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ChoiceNoOtherwiseTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint end;

    @Test
    public void testNoOtherwise() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().simple("${header.foo} == 'bar'")).to("mock:x")).end().to("mock:end");
            }
        });
        this.context.start();
        this.x.expectedBodiesReceived(new Object[]{"a"});
        this.end.expectedBodiesReceived(new Object[]{"a", "b"});
        this.sendMessage("bar", "a");
        this.sendMessage("cheese", "b");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNoOtherwiseTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${header.foo} == 'bar'")).to("mock:x")).end().to("mock:end");
            }
        });
        this.context.start();
        this.x.expectedBodiesReceived(new Object[]{"a"});
        this.end.expectedBodiesReceived(new Object[]{"a", "b"});
        this.sendMessage("bar", "a");
        this.sendMessage("cheese", "b");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmptyOtherwise() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().simple("${header.foo} == 'bar'")).to("mock:x")).otherwise().end().to("mock:end");
            }
        });
        this.context.start();
        this.x.expectedBodiesReceived(new Object[]{"a"});
        this.end.expectedBodiesReceived(new Object[]{"a", "b"});
        this.sendMessage("bar", "a");
        this.sendMessage("cheese", "b");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmptyOtherwiseTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${header.foo} == 'bar'")).to("mock:x")).otherwise().end().to("mock:end");
            }
        });
        this.context.start();
        this.x.expectedBodiesReceived(new Object[]{"a"});
        this.end.expectedBodiesReceived(new Object[]{"a", "b"});
        this.sendMessage("bar", "a");
        this.sendMessage("cheese", "b");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(Object headerValue, Object body) {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.end = this.getMockEndpoint("mock:end");
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

