/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChoiceNoErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testChoiceNoErrorHandler() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((ChoiceDefinition)this.from("direct:start").choice().when(this.header("foo").isEqualTo((Object)"bar")).to("direct:end")).otherwise().end();
                ((RouteDefinition)this.from("direct:end").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody(String.class));
                    }
                })).to("mock:result");
            }
        };
    }
}

