/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ChoiceInPreconditionModeTest
extends ContextTestSupport {
    ChoiceInPreconditionModeTest() {
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    void testRed() throws Exception {
        Properties init = new Properties();
        init.setProperty("red", "true");
        init.setProperty("blue", "false");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:red").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Red");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getProcessor("mySwitch"));
        Assertions.assertNotNull((Object)this.context.getProcessor("myRed"));
        Assertions.assertNull((Object)this.context.getProcessor("myBlue"));
        Assertions.assertNull((Object)this.context.getProcessor("myYellow"));
    }

    @Test
    void testBlue() throws Exception {
        Properties init = new Properties();
        init.setProperty("red", "false");
        init.setProperty("blue", "true");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:blue").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Blue");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getProcessor("mySwitch"));
        Assertions.assertNull((Object)this.context.getProcessor("myRed"));
        Assertions.assertNotNull((Object)this.context.getProcessor("myBlue"));
        Assertions.assertNull((Object)this.context.getProcessor("myYellow"));
    }

    @Test
    void testYellow() throws Exception {
        Properties init = new Properties();
        init.setProperty("red", "false");
        init.setProperty("blue", "false");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:yellow").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Yellow");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getProcessor("mySwitch"));
        Assertions.assertNull((Object)this.context.getProcessor("myRed"));
        Assertions.assertNull((Object)this.context.getProcessor("myBlue"));
        Assertions.assertNotNull((Object)this.context.getProcessor("myYellow"));
    }

    @Test
    void testNone() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").routeId("myRoute").choice().precondition().id("mySwitch")).when((Predicate)this.simple("{{?red}}")).to("mock:red")).id("myRed")).when((Predicate)this.simple("{{?blue}}")).to("mock:blue")).id("myBlue")).end().to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Yellow");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getProcessor("mySwitch"));
        Assertions.assertNull((Object)this.context.getProcessor("myRed"));
        Assertions.assertNull((Object)this.context.getProcessor("myBlue"));
        Assertions.assertNull((Object)this.context.getProcessor("myYellow"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").routeId("myRoute").choice().precondition(true).id("mySwitch")).when((Predicate)this.simple("{{red}}")).to("mock:red")).id("myRed")).when((Predicate)this.simple("{{blue}}")).to("mock:blue")).id("myBlue")).otherwise().to("mock:yellow")).id("myYellow");
            }
        };
    }
}

