/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class ChoiceCompoundPredicateSimpleTest
extends ContextTestSupport {
    @Test
    public void testNull() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(2);
        this.getMockEndpoint("mock:data").expectedMessageCount(0);
        this.template.sendBody("direct:simple", null);
        this.template.sendBody("direct:or", null);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmpty() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(2);
        this.getMockEndpoint("mock:data").expectedMessageCount(0);
        this.template.sendBody("direct:simple", new ArrayList());
        this.template.sendBody("direct:or", new ArrayList());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmptyOr() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(1);
        this.getMockEndpoint("mock:data").expectedMessageCount(0);
        this.template.sendBody("direct:or", new ArrayList());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmptySimple() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(1);
        this.getMockEndpoint("mock:data").expectedMessageCount(0);
        this.template.sendBody("direct:simple", new ArrayList());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testData() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(0);
        this.getMockEndpoint("mock:data").expectedMessageCount(2);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Hello Camel");
        this.template.sendBody("direct:simple", list);
        this.template.sendBody("direct:or", list);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataOr() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(0);
        this.getMockEndpoint("mock:data").expectedMessageCount(1);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Hello Camel");
        this.template.sendBody("direct:or", list);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataSimple() throws Exception {
        this.getMockEndpoint("mock:empty").expectedMessageCount(0);
        this.getMockEndpoint("mock:data").expectedMessageCount(1);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Hello Camel");
        this.template.sendBody("direct:simple", list);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:or").choice().when(PredicateBuilder.or((Predicate)this.body().isNull(), (Predicate)this.simple("${body.size()} == 0"))).to("mock:empty")).otherwise().to("mock:data")).end();
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:simple").choice().when((Predicate)this.simple("${body} == null || ${body.size()} == 0")).to("mock:empty")).otherwise().to("mock:data")).end();
            }
        };
    }
}

