/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Camel715ThreadProcessorTest {
    private static final int ITERS = 50000;

    @Test
    public void testThreadProcessor() throws Exception {
        int i;
        DefaultCamelContext context = new DefaultCamelContext();
        final CountDownLatch latch = new CountDownLatch(50000);
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)this.from("direct:a").threads(4).to("mock:input")).process(new Processor(){

                    public void process(Exchange ex) {
                        latch.countDown();
                    }
                });
            }
        });
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:input", MockEndpoint.class);
        mock.expectedMessageCount(50000);
        ProducerTemplate template = context.createProducerTemplate();
        Endpoint e = context.getEndpoint("direct:a");
        context.start();
        for (i = 0; i < 50000; ++i) {
            template.send(e, (Processor)new SendingProcessor(i));
        }
        MockEndpoint.assertIsSatisfied((long)30L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[0]);
        latch.await(30L, TimeUnit.SECONDS);
        for (i = 0; i < 50000; ++i) {
            Integer number = (Integer)((Exchange)mock.getReceivedExchanges().get(i)).getProperty("iterationNumber", Integer.class);
            Assertions.assertNotNull((Object)number);
            Assertions.assertEquals((int)i, (int)number);
        }
        context.stop();
    }

    static class SendingProcessor
    implements Processor {
        final int iterationNumber;

        public SendingProcessor(int iter) {
            this.iterationNumber = iter;
        }

        public void process(Exchange exchange) {
            Message in = exchange.getIn();
            in.setBody((Object)"a");
            exchange.setProperty("iterationNumber", (Object)this.iterationNumber);
        }
    }
}

