/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class CBRWithWireTapTest
extends ContextTestSupport {
    @Test
    public void testCBRWithWireTapCamel() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:camel").expectedMessageCount(1);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Camel rules");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCBRWithWireTapDonkey() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:camel").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Donkey kong");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCBRWithWireTapOther() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:camel").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).wireTap("mock:camel").end()).when(this.body().contains((Object)"Donkey")).wireTap("mock:donkey").end()).otherwise().to("mock:other");
            }
        };
    }
}

