/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Test;

public class CBRWithMulticastTest
extends ContextTestSupport {
    @Test
    public void testOneMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Camel rules");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTwoMesssages() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Camel rules");
        this.template.sendBody("direct:start", (Object)"Camel rocks");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testResult() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).multicast().to("mock:foo")).to("mock:bar")).endChoice().otherwise().to("mock:result");
            }
        };
    }
}

