/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CBRPredicateBeanThrowExceptionTest
extends ContextTestSupport {
    private static final AtomicBoolean check = new AtomicBoolean();
    private static final AtomicBoolean check2 = new AtomicBoolean();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("cbrBean", (Object)new MyCBRBean());
        return jndi;
    }

    @Test
    public void testCBR() throws Exception {
        check.set(false);
        check2.set(false);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Foo", "foo", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Bar", "foo", (Object)"other");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)check.get());
        Assertions.assertTrue((boolean)check2.get());
    }

    @Test
    public void testCBRKaboom() throws Exception {
        check.set(false);
        check2.set(false);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo2").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Foo", "foo", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)check.get());
        Assertions.assertFalse((boolean)check2.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().method("cbrBean", "checkHeader")).to("mock:foo")).when().method("cbrBean", "checkHeader2")).to("mock:foo2")).otherwise().to("mock:bar")).end();
            }
        };
    }

    public static class MyCBRBean {
        public boolean checkHeader(Exchange exchange) {
            check.set(true);
            Message inMsg = exchange.getIn();
            String foo = (String)inMsg.getHeader("foo");
            if ("Kaboom".equalsIgnoreCase(foo)) {
                throw new IllegalArgumentException("Forced");
            }
            return foo.equals("bar");
        }

        public boolean checkHeader2(Exchange exchange) {
            check2.set(true);
            Message inMsg = exchange.getIn();
            String foo = (String)inMsg.getHeader("foo");
            if ("Kaboom".equalsIgnoreCase(foo)) {
                throw new IllegalArgumentException("Forced");
            }
            return foo.equals("bar");
        }
    }
}

