/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.xpath.XPath;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithXPathInjectionPreCompileTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithXPathInjectionPreCompileTest.class);
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)expectedBody, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"bar", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
    }

    @Test
    public void testSendTwoMessages() {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)expectedBody, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"bar", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
        String expectedBody2 = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>baz</foo></env:Body></env:Envelope>";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody2, "foo", (Object)"baz");
        Assertions.assertEquals((Object)expectedBody2, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"baz", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        public String body;
        public String foo;

        public String toString() {
            return "MyBean[foo: " + this.foo + " body: " + this.body + "]";
        }

        public void read(String body, @XPath(value="/soap:Envelope/soap:Body/foo/text()", preCompile=false) String foo) {
            this.foo = foo;
            this.body = body;
            LOG.info("read() method called on {}", (Object)this);
        }
    }
}

