/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Header;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithExceptionTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    @Test
    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"<valid/>");
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.setProperty("cheese", (Object)"old");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.invalidEndpoint.expectedMessageCount(1);
        Exchange exchange = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"<invalid/>");
                exchange.getIn().setHeader("foo", (Object)"notMatchedHeaderValue");
                exchange.setProperty("cheese", (Object)"old");
            }
        });
        Assertions.assertNotNull((Object)exchange.getException());
        ValidationException exception = BeanWithExceptionTest.assertIsInstanceOf(ValidationException.class, exchange.getException());
        Assertions.assertEquals((Object)"Invalid header foo: notMatchedHeaderValue", (Object)exception.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new ValidationBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(ValidationException.class).to("mock:invalid");
                ((RouteDefinition)this.from("direct:start").bean((Object)"myBean")).to("mock:valid");
            }
        };
    }

    public static class ValidationBean {
        private static final Logger LOG = LoggerFactory.getLogger(ValidationBean.class);

        public void someMethod(String body, @Header(value="foo") String header, @ExchangeProperty(value="cheese") String cheese) throws ValidationException {
            Assertions.assertEquals((Object)"old", (Object)cheese);
            if (!"bar".equals(header)) {
                throw new ValidationException(null, "Invalid header foo: " + header);
            }
            LOG.info("someMethod() called with valid header and body: {}", (Object)body);
        }
    }
}

