/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jndi.JndiBeanRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanSingletonTest
extends ContextTestSupport {
    private Context context;
    private Registry registry;

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:noCache").to("bean:something?scope=Prototype");
                this.from("direct:cached").to("bean:something?scope=Singleton");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        this.context = this.createJndiContext();
        this.context.bind("something", (Object)new MyBean());
        this.registry = new DefaultRegistry(new BeanRepository[]{new JndiBeanRepository(this.context)});
        return this.registry;
    }

    @Test
    public void testFreshBeanInContext() throws Exception {
        MyBean originalInstance = (MyBean)this.registry.lookupByNameAndType("something", MyBean.class);
        this.template.sendBody("direct:noCache", null);
        this.context.unbind("something");
        this.context.bind("something", (Object)new MyBean());
        Assertions.assertNotSame((Object)this.registry.lookupByName("something"), (Object)originalInstance);
        this.template.sendBody("direct:noCache", null);
    }

    @Test
    public void testBeanWithSingleton() throws Exception {
        MyBean originalInstance = (MyBean)this.registry.lookupByNameAndType("something", MyBean.class);
        this.template.sendBody("direct:cached", null);
        this.context.unbind("something");
        this.context.bind("something", (Object)new MyBean());
        Assertions.assertNotSame((Object)this.registry.lookupByName("something"), (Object)originalInstance);
        try {
            this.template.sendBody("direct:cached", null);
            Assertions.fail((String)"The IllegalStateException is expected");
        }
        catch (CamelExecutionException ex) {
            boolean b = ex.getCause() instanceof IllegalStateException;
            Assertions.assertTrue((boolean)b, (String)"IllegalStateException is expected!");
            Assertions.assertEquals((Object)"This bean is not supported to be invoked again!", (Object)ex.getCause().getMessage());
        }
    }

    public static class MyBean {
        private boolean invoked;

        public void doSomething(Exchange exchange) {
            if (this.invoked) {
                throw new IllegalStateException("This bean is not supported to be invoked again!");
            }
            this.invoked = true;
        }
    }
}

