/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRecipientListTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRecipientListTest.class);
    protected final MyBean myBean = new MyBean();

    @Test
    public void testSendMessage() throws Exception {
        String expectedBody = "Wibble";
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Wibble"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Wibble"});
        this.template.sendBody("direct:in", (Object)"Wibble");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.checkBean();
    }

    protected void checkBean() {
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        Assertions.assertSame((Object)this.myBean, (Object)lookedUpBean, (String)"Lookup of 'myBean' should return same object!");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean", "route");
            }
        };
    }

    public static class MyBean {
        private static final AtomicInteger counter = new AtomicInteger();
        private final int id = counter.incrementAndGet();

        public String toString() {
            return "MyBean:" + this.id;
        }

        @RecipientList
        public String[] route(String body) {
            LOG.debug("Called {} with body: {}", (Object)this, (Object)body);
            return new String[]{"mock:a", "mock:b"};
        }
    }
}

