/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.xpath.XPath;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanOgnMethodWithXPathInjectionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanOgnMethodWithXPathInjectionTest.class);
    protected final MyBean myBean = new MyBean();
    protected final MyOtherBean myOtherBean = new MyOtherBean(this.myBean);

    @Test
    public void testSendMessage() {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        Object out = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)out);
        Assertions.assertEquals((Object)expectedBody, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"bar", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
    }

    @Test
    public void testSendTwoMessages() {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        Object out = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)out);
        Assertions.assertEquals((Object)expectedBody, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"bar", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
        String expectedBody2 = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>baz</foo></env:Body></env:Envelope>";
        Object out2 = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody2, "foo", (Object)"bar");
        Assertions.assertEquals((Object)"baz", (Object)out2);
        Assertions.assertEquals((Object)expectedBody2, (Object)this.myBean.body, (String)("bean body: " + String.valueOf(this.myBean)));
        Assertions.assertEquals((Object)"baz", (Object)this.myBean.foo, (String)("bean foo: " + String.valueOf(this.myBean)));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        answer.bind("myOtherBean", (Object)this.myOtherBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").transform().method("myOtherBean", "doSomething.read");
            }
        };
    }

    public static class MyBean {
        public String body;
        public String foo;

        public String toString() {
            return "MyBean[foo: " + this.foo + " body: " + this.body + "]";
        }

        public String read(String body, @XPath(value="/soap:Envelope/soap:Body/foo/text()") String foo) {
            this.foo = foo;
            this.body = body;
            LOG.info("read() method called on {}", (Object)this);
            return foo;
        }
    }

    public static class MyOtherBean {
        private final MyBean inner;

        public MyOtherBean(MyBean inner) {
            this.inner = inner;
        }

        public MyBean doSomething() {
            return this.inner;
        }
    }
}

