/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanInvocationThrowsExceptionTest
extends ContextTestSupport {
    @Test
    public void testBeanInvocation() {
        int result = (Integer)this.template.sendBody("direct:input", ExchangePattern.InOut, (Object)"Hello London");
        Assertions.assertEquals((int)1, (int)result);
    }

    @Test
    public void testBeanInvocationFailure() {
        Exchange exchange = this.getMandatoryEndpoint("direct:input").createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"Hello Paris");
        Exchange out = this.template.send("direct:input", exchange);
        Assertions.assertTrue((boolean)out.isFailed(), (String)"Should be failed");
        boolean b = out.getException() instanceof IllegalArgumentException;
        Assertions.assertTrue((boolean)b, (String)"Should be IllegalArgumentException");
        Assertions.assertEquals((Object)"Forced exception", (Object)out.getException().getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:input").bean((Object)new ExceptionBean());
            }
        };
    }

    public static class ExceptionBean {
        public int doSomething(String request) {
            if (request.equals("Hello London")) {
                return 1;
            }
            throw new IllegalArgumentException("Forced exception");
        }
    }
}

