/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class BatchResequencerWithDuplicateTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testBatchResequencerAllowDuplicate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.header("id")).allowDuplicates().to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"1A", "1B", "2C", "2D", "2E", "2F", "3G", "4H"});
        this.template.sendBodyAndHeader("direct:start", (Object)"1A", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"2C", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"2D", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"4H", "id", (Object)"4");
        this.template.sendBodyAndHeader("direct:start", (Object)"1B", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"2E", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"3G", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"2F", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBatchResequencerNoDuplicate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.header("id")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A", "C", "E", "F"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)"4");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }
}

