/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class BatchResequencerAllowDuplicatesTest
extends ContextTestSupport {
    @Test
    public void testBatchResequencerAllowDuplicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"1A", "1B", "2C", "2D", "2E", "2F", "3G", "4H"});
        this.template.sendBodyAndHeader("direct:start", (Object)"1A", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"2C", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"2D", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"4H", "id", (Object)"4");
        this.template.sendBodyAndHeader("direct:start", (Object)"1B", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"2E", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"3G", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"2F", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.header("id")).allowDuplicates().to("mock:result");
            }
        };
    }
}

