/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncLoopCopyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testAsyncLoopCopy() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:loopIterationStart").expectedBodiesReceived(new Object[]{"Hello Camel", "Hello Camel"});
        this.getMockEndpoint("mock:loopIterationEnd").expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBodyAndHeader("direct:start", (Object)"Hello Camel", "NumberIterations", (Object)2, String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AsyncLoopCopyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).loop((Expression)this.header("NumberIterations")).copy().to("mock:loopIterationStart")).to("async:bye:camel")).to("mock:loopIterationEnd")).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                }).to("log:after").to("mock:result");
            }
        };
    }
}

