/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Timeout(value=30L)
public class AggregateParallelThreadPoolCallerRunsTest
extends ContextTestSupport {
    @Test
    public void testAggregateParallel() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(5);
        AtomicInteger ok = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        Runnable r = () -> {
            try {
                this.template.sendBody("direct:start", (Object)"Body");
                ok.incrementAndGet();
            }
            catch (Exception e) {
                fail.incrementAndGet();
            }
        };
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            pool.submit(r);
        }
        Awaitility.await().untilAsserted(() -> Assertions.assertEquals((int)10, (int)ok.get(), (String)"All should be ok"));
        this.assertMockEndpointsSatisfied();
        this.log.info("Errors: {}", (Object)fail.get());
        this.log.info("OK: {}", (Object)ok.get());
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ExecutorService executorService = new ThreadPoolBuilder(this.getContext()).poolSize(1).maxPoolSize(1).maxQueueSize(0).build("inner");
                this.from("direct:start").to("direct:inner?synchronous=true");
                ((ExpressionNode)this.from("direct:inner").aggregate((Expression)this.constant(true), (AggregationStrategy)new BodyInAggregatingStrategy()).executorService(executorService).completionSize(2).delay(1000L).log("${body}")).to("mock:result");
            }
        };
    }
}

