/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.model.dataformat.DummyDataformat;
import org.apache.camel.spi.DataFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataFormatRegistrationTest
extends ContextTestSupport {
    @Test
    public void shouldRegisterDataformatInCacheTest() throws Exception {
        DummyDataformat df = (DummyDataformat)this.context.resolveDataFormat("dummy");
        df.setName("DUMMMY");
        df.setVersion("2.3.6");
        Field field = AbstractCamelContext.class.getDeclaredField("dataformats");
        field.setAccessible(true);
        Map dataformats = (Map)field.get(this.context);
        Assertions.assertThat((Map)dataformats).containsKey((Object)"dummy");
        DummyDataformat df2 = (DummyDataformat)this.context.resolveDataFormat("dummy");
        dataformats = (Map)field.get(this.context);
        Assertions.assertThat((Map)dataformats).containsKey((Object)"dummy");
        Assertions.assertThat((String)df2.getName()).isEqualTo(df.getName()).isEqualTo("DUMMMY");
        Assertions.assertThat((String)df2.getVersion()).isEqualTo(df.getVersion()).isEqualTo("2.3.6");
    }

    @Test
    public void missingDataformatTest() throws Exception {
        DataFormat df = this.context.resolveDataFormat("nonExistent");
        Field field = AbstractCamelContext.class.getDeclaredField("dataformats");
        field.setAccessible(true);
        Map dataformats = (Map)field.get(this.context);
        Assertions.assertThat((Map)dataformats).isEmpty();
    }
}

