/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.net.URL;
import org.apache.camel.TestSupport;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.rest.RestContainer;
import org.apache.camel.xml.jaxb.DefaultModelJAXBContextFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlTestSupport
extends TestSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected JAXBContext jaxbContext;

    protected RouteContainer assertParseAsJaxb(String uri) throws JAXBException {
        Object value = this.parseUri(uri);
        RouteContainer context = XmlTestSupport.assertIsInstanceOf(RouteContainer.class, value);
        this.log.info("Found: {}", (Object)context);
        return context;
    }

    protected RestContainer assertParseRestAsJaxb(String uri) throws JAXBException {
        Object value = this.parseUri(uri);
        RestContainer context = XmlTestSupport.assertIsInstanceOf(RestContainer.class, value);
        this.log.info("Found: {}", (Object)context);
        return context;
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = this.getClass().getResource(uri);
        Assertions.assertNotNull((Object)resource, (String)("Cannot find resource on the classpath: " + uri));
        return unmarshaller.unmarshal(resource);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = XmlTestSupport.createJaxbContext();
    }

    public static JAXBContext createJaxbContext() throws JAXBException {
        return new DefaultModelJAXBContextFactory().newJAXBContext();
    }
}

