/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.JAXBException;
import java.util.List;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ConvertHeaderDefinition;
import org.apache.camel.model.ConvertVariableDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlParseTest
extends XmlTestSupport {
    @Test
    public void testParseSimpleRouteXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("simpleRoute.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo("to", (OutputNode)route, "seda:b");
    }

    @Test
    public void testParseProcessorXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processor.xml");
        this.assertFrom(route, "seda:a");
        ProcessDefinition to = this.assertOneProcessorInstanceOf(ProcessDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"myProcessor", (Object)to.getRef(), (String)"Processor ref");
    }

    @Test
    public void testParseProcessorWithFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf(FilterDefinition.class, (OutputNode)route);
        this.assertExpression(filter.getExpression(), "juel", "in.header.foo == 'bar'");
    }

    @Test
    public void testParseProcessorWithHeaderFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithHeaderFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf(FilterDefinition.class, (OutputNode)route);
        this.assertExpression(filter.getExpression(), "header", "foo");
    }

    @Test
    public void testParseProcessorWithSimpleFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithSimpleFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf(FilterDefinition.class, (OutputNode)route);
        this.assertExpression(filter.getExpression(), "simple", "${in.header.foo} == 'bar'");
    }

    @Test
    public void testParseProcessorWithGroovyFilterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("processorWithGroovyFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterDefinition filter = this.assertOneProcessorInstanceOf(FilterDefinition.class, (OutputNode)route);
        this.assertExpression(filter.getExpression(), "groovy", "in.headers.any { h -> h.startsWith('foo')}");
    }

    @Test
    public void testParseRecipientListXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("dynamicRecipientList.xml");
        this.assertFrom(route, "seda:a");
        RecipientListDefinition node = this.assertOneProcessorInstanceOf(RecipientListDefinition.class, (OutputNode)route);
        this.assertExpression(node.getExpression(), "header", "foo");
    }

    @Test
    public void testParseStaticRecipientListXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("staticRecipientList.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo((OutputNode)route, "seda:b", "seda:c", "seda:d");
    }

    @Test
    public void testParseTransformXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("transform.xml");
        this.assertFrom(route, "direct:start");
        TransformDefinition node = this.assertNthProcessorInstanceOf(TransformDefinition.class, (OutputNode)route, 0);
        this.assertExpression(node.getExpression(), "simple", "${in.body} extra data!");
        this.assertChildTo((OutputNode)route, "mock:end", 1);
    }

    @Test
    public void testParseSagaXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("saga.xml");
        this.assertFrom(route, "direct:start");
        SagaDefinition node = this.assertNthProcessorInstanceOf(SagaDefinition.class, (OutputNode)route, 0);
        Assertions.assertNotNull((Object)node.getCompensation());
        this.assertChildTo((OutputNode)route, "mock:end", 2);
    }

    @Test
    public void testParseScriptXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("script.xml");
        this.assertFrom(route, "direct:start");
        ScriptDefinition node = this.assertNthProcessorInstanceOf(ScriptDefinition.class, (OutputNode)route, 0);
        this.assertExpression(node.getExpression(), "groovy", "System.out.println(\"groovy was here\")");
        this.assertChildTo((OutputNode)route, "mock:end", 1);
    }

    @Test
    public void testParseSetBodyXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setBody.xml");
        this.assertFrom(route, "direct:start");
        SetBodyDefinition node = this.assertNthProcessorInstanceOf(SetBodyDefinition.class, (OutputNode)route, 0);
        this.assertExpression(node.getExpression(), "simple", "${in.body} extra data!");
        this.assertChildTo((OutputNode)route, "mock:end", 1);
    }

    @Test
    public void testParseSetHeaderXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setHeader.xml");
        this.assertFrom(route, "seda:a");
        SetHeaderDefinition node = this.assertNthProcessorInstanceOf(SetHeaderDefinition.class, (OutputNode)route, 0);
        Assertions.assertEquals((Object)"oldBodyValue", (Object)node.getName());
        this.assertExpression(node.getExpression(), "simple", "body");
        this.assertChildTo((OutputNode)route, "mock:b", 1);
    }

    @Test
    public void testParseSetHeaderToConstantXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("setHeaderToConstant.xml");
        this.assertFrom(route, "seda:a");
        SetHeaderDefinition node = this.assertNthProcessorInstanceOf(SetHeaderDefinition.class, (OutputNode)route, 0);
        Assertions.assertEquals((Object)"theHeader", (Object)node.getName());
        this.assertExpression(node.getExpression(), "constant", "a value");
        this.assertChildTo((OutputNode)route, "mock:b", 1);
    }

    @Test
    public void testParseConvertBodyXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("convertBody.xml");
        this.assertFrom(route, "seda:a");
        ConvertBodyDefinition node = this.assertOneProcessorInstanceOf(ConvertBodyDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)node.getType());
    }

    @Test
    public void testParseConvertHeaderXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("convertHeader.xml");
        this.assertFrom(route, "seda:a");
        ConvertHeaderDefinition node = this.assertOneProcessorInstanceOf(ConvertHeaderDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"foo", (Object)node.getName());
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)node.getType());
    }

    @Test
    public void testParseConvertVariableXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("convertVariable.xml");
        this.assertFrom(route, "seda:a");
        ConvertVariableDefinition node = this.assertOneProcessorInstanceOf(ConvertVariableDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"foo", (Object)node.getName());
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)node.getType());
    }

    @Test
    public void testParseRoutingSlipXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlip.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf(RoutingSlipDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"destinations", (Object)node.getExpression().getExpression());
        Assertions.assertEquals((Object)",", (Object)node.getUriDelimiter());
    }

    @Test
    public void testParseRoutingSlipWithHeaderSetXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlipHeaderSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf(RoutingSlipDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"theRoutingSlipHeader", (Object)node.getExpression().getExpression());
        Assertions.assertEquals((Object)",", (Object)node.getUriDelimiter());
    }

    @Test
    public void testParseRoutingSlipWithHeaderAndDelimiterSetXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routingSlipHeaderAndDelimiterSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipDefinition node = this.assertOneProcessorInstanceOf(RoutingSlipDefinition.class, (OutputNode)route);
        Assertions.assertEquals((Object)"theRoutingSlipHeader", (Object)node.getExpression().getExpression());
        Assertions.assertEquals((Object)"#", (Object)node.getUriDelimiter());
    }

    @Test
    public void testParseRouteWithChoiceXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithChoice.xml");
        this.assertFrom(route, "seda:a");
        ChoiceDefinition choice = this.assertOneProcessorInstanceOf(ChoiceDefinition.class, (OutputNode)route);
        List whens = XmlParseTest.assertListSize(choice.getWhenClauses(), 2);
        this.assertChildTo("when(0)", (OutputNode)whens.get(0), "seda:b");
        this.assertChildTo("when(1)", (OutputNode)whens.get(1), "seda:c");
        OtherwiseDefinition otherwise = choice.getOtherwise();
        Assertions.assertNotNull((Object)otherwise, (String)"Otherwise is null");
        this.assertChildTo("otherwise", (OutputNode)otherwise, "seda:d");
    }

    @Test
    public void testParseSplitterXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("splitter.xml");
        this.assertFrom(route, "seda:a");
        SplitDefinition splitter = this.assertOneProcessorInstanceOf(SplitDefinition.class, (OutputNode)route);
        this.assertExpression(splitter.getExpression(), "xpath", "/foo/bar");
        this.assertChildTo("to", (OutputNode)splitter, "seda:b");
    }

    @Test
    public void testParseLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf(LoadBalanceDefinition.class, (OutputNode)route);
        Assertions.assertEquals((int)3, (int)loadBalance.getOutputs().size(), (String)"Here should have 3 output here");
        boolean b = loadBalance.getLoadBalancerType() instanceof RoundRobinLoadBalancerDefinition;
        Assertions.assertTrue((boolean)b, (String)"The loadBalancer should be RoundRobinLoadBalancerDefinition");
    }

    @Test
    public void testParseStickyLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithStickyLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf(LoadBalanceDefinition.class, (OutputNode)route);
        Assertions.assertEquals((int)3, (int)loadBalance.getOutputs().size(), (String)"Here should have 3 output here");
        boolean b = loadBalance.getLoadBalancerType() instanceof StickyLoadBalancerDefinition;
        Assertions.assertTrue((boolean)b, (String)"The loadBalancer should be StickyLoadBalancerDefinition");
        StickyLoadBalancerDefinition strategy = (StickyLoadBalancerDefinition)loadBalance.getLoadBalancerType();
        Assertions.assertNotNull((Object)strategy.getCorrelationExpression(), (String)"the expression should not be null ");
    }

    @Test
    public void testParseFailoverLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithFailoverLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf(LoadBalanceDefinition.class, (OutputNode)route);
        Assertions.assertEquals((int)3, (int)loadBalance.getOutputs().size(), (String)"Here should have 3 output here");
        boolean b = loadBalance.getLoadBalancerType() instanceof FailoverLoadBalancerDefinition;
        Assertions.assertTrue((boolean)b, (String)"The loadBalancer should be FailoverLoadBalancerDefinition");
        FailoverLoadBalancerDefinition strategy = (FailoverLoadBalancerDefinition)loadBalance.getLoadBalancerType();
        Assertions.assertEquals((int)2, (int)strategy.getExceptions().size(), (String)"there should be 2 exceptions");
    }

    @Test
    public void testParseRandomLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithRandomLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf(LoadBalanceDefinition.class, (OutputNode)route);
        Assertions.assertEquals((int)3, (int)loadBalance.getOutputs().size(), (String)"Here should have 3 output here");
        boolean b = loadBalance.getLoadBalancerType() instanceof RandomLoadBalancerDefinition;
        Assertions.assertTrue((boolean)b, (String)"The loadBalancer should be RandomLoadBalancerDefinition");
    }

    @Test
    public void testParseTopicLoadBalance() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithTopicLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceDefinition loadBalance = this.assertOneProcessorInstanceOf(LoadBalanceDefinition.class, (OutputNode)route);
        Assertions.assertEquals((int)3, (int)loadBalance.getOutputs().size(), (String)"Here should have 3 output here");
        boolean b = loadBalance.getLoadBalancerType() instanceof TopicLoadBalancerDefinition;
        Assertions.assertTrue((boolean)b, (String)"The loadBalancer should be TopicLoadBalancerDefinition");
    }

    @Test
    public void testParseHL7DataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithHL7DataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseXMLSecurityDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithXMLSecurityDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseTidyMarkupDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithTidyMarkupDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseTidyMarkupDataFormatAndAllowNullBody() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithTidyMarkupDataFormatAndAllowNullBody.xml");
        this.assertFrom(route, "seda:a");
        UnmarshalDefinition unmarshal = this.assertNthProcessorInstanceOf(UnmarshalDefinition.class, (OutputNode)route, 0);
        Assertions.assertEquals((Object)"true", (Object)unmarshal.getAllowNullBody(), (String)"The unmarshaller should allow null body");
    }

    @Test
    public void testParseRSSDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithRSSDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseJSonDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithJSonDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseJaxbDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithJaxbDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseFlatpackDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithFlatpackDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseCvsDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithCvsDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseZipFileDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithZipFileDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseBindyDataFormat() throws Exception {
        RouteDefinition route = this.assertOneRoute("routeWithBindyDataFormat.xml");
        this.assertFrom(route, "seda:a");
    }

    @Test
    public void testParseBatchResequencerXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("resequencerBatch.xml");
        ResequenceDefinition resequencer = this.assertOneProcessorInstanceOf(ResequenceDefinition.class, (OutputNode)route);
        Assertions.assertNull((Object)resequencer.getStreamConfig());
        Assertions.assertNotNull((Object)resequencer.getBatchConfig());
        Assertions.assertEquals((Object)Integer.toString(500), (Object)resequencer.getBatchConfig().getBatchSize());
        Assertions.assertEquals((Object)Long.toString(2000L), (Object)resequencer.getBatchConfig().getBatchTimeout());
    }

    @Test
    public void testParseStreamResequencerXml() throws Exception {
        RouteDefinition route = this.assertOneRoute("resequencerStream.xml");
        ResequenceDefinition resequencer = this.assertOneProcessorInstanceOf(ResequenceDefinition.class, (OutputNode)route);
        Assertions.assertNotNull((Object)resequencer.getStreamConfig());
        Assertions.assertNull((Object)resequencer.getBatchConfig());
        Assertions.assertEquals((Object)Integer.toString(1000), (Object)resequencer.getStreamConfig().getCapacity());
        Assertions.assertEquals((Object)Long.toString(2000L), (Object)resequencer.getStreamConfig().getTimeout());
    }

    @Test
    public void testLoop() throws Exception {
        RouteDefinition route = this.assertOneRoute("loop.xml");
        LoopDefinition loop = this.assertOneProcessorInstanceOf(LoopDefinition.class, (OutputNode)route);
        Assertions.assertNotNull((Object)loop.getExpression());
        Assertions.assertEquals((Object)"constant", (Object)loop.getExpression().getLanguage());
    }

    protected RouteDefinition assertOneRoute(String uri) throws JAXBException {
        RouteContainer context = this.assertParseAsJaxb(uri);
        return (RouteDefinition)XmlParseTest.assertOneElement(context.getRoutes());
    }

    protected void assertFrom(RouteDefinition route, String uri) {
        FromDefinition from = route.getInput();
        Assertions.assertEquals((Object)uri, (Object)from.getUri(), (String)"From URI");
    }

    protected void assertChildTo(String message, OutputNode route, String uri) {
        ProcessorDefinition processor = (ProcessorDefinition)XmlParseTest.assertOneElement(route.getOutputs());
        ToDefinition value = XmlParseTest.assertIsInstanceOf(ToDefinition.class, processor);
        String text = message + "To URI";
        this.log.info("Testing: {} is equal to: {} for processor: {}", new Object[]{text, uri, processor});
        Assertions.assertEquals((Object)uri, (Object)value.getUri(), (String)text);
    }

    protected void assertTo(String message, ProcessorDefinition<?> processor, String uri) {
        ToDefinition value = XmlParseTest.assertIsInstanceOf(ToDefinition.class, processor);
        String text = message + "To URI";
        this.log.info("Testing: {} is equal to: {} for processor: {}", new Object[]{text, uri, processor});
        Assertions.assertEquals((Object)uri, (Object)value.getUri(), (String)text);
    }

    protected void assertChildTo(OutputNode route, String ... uris) {
        List list = XmlParseTest.assertListSize(route.getOutputs(), uris.length);
        int idx = 0;
        for (String uri : uris) {
            this.assertTo("output[" + idx + "] ", (ProcessorDefinition)list.get(idx++), uri);
        }
    }

    protected void assertChildTo(OutputNode route, String uri, int toIdx) {
        List list = route.getOutputs();
        this.assertTo("to and idx=" + toIdx, (ProcessorDefinition)list.get(toIdx), uri);
    }

    protected <T> T assertOneProcessorInstanceOf(Class<T> type, OutputNode route) {
        ProcessorDefinition processor = (ProcessorDefinition)XmlParseTest.assertOneElement(route.getOutputs());
        return XmlParseTest.assertIsInstanceOf(type, processor);
    }

    protected <T> T assertNthProcessorInstanceOf(Class<T> type, OutputNode route, int index) {
        ProcessorDefinition processor = (ProcessorDefinition)route.getOutputs().get(index);
        return XmlParseTest.assertIsInstanceOf(type, processor);
    }

    protected void assertExpression(ExpressionDefinition expression, String language, String languageExpression) {
        Assertions.assertNotNull((Object)expression, (String)"Expression should not be null!");
        Assertions.assertEquals((Object)language, (Object)expression.getLanguage(), (String)"Expression language");
        Assertions.assertEquals((Object)languageExpression, (Object)expression.getExpression(), (String)"Expression");
    }
}

