/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartingRoutesErrorReportedTest
extends ContextTestSupport {
    @Test
    public void testInvalidFrom() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start?foo=bar").routeId("route1").to("mock:result");
                }
            });
            this.context.start();
        });
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route1: Route(route1)[From[direct:start?foo=bar] -> [To[mock:result]... because of"));
    }

    @Test
    public void testInvalidTo() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").routeId("route2").to("direct:result?foo=bar");
                }
            });
            this.context.start();
        });
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route2 at: >>> To[direct:result?foo=bar] <<< in route:"));
    }

    @Test
    public void testMaskPassword() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("stub:foo?password=secret&beer=yes").routeId("route2").to("direct:result?foo=bar");
                }
            });
            this.context.start();
        });
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route2 at: >>> To[direct:result?foo=bar] <<< in route:"));
    }

    @Test
    public void testInvalidBean() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.from("direct:start").routeId("route3").to("mock:foo")).bean((Object)"");
                }
            });
            this.context.start();
        }, (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route3 at: >>> Bean[ref:] <<< in route:"));
    }

    @Test
    public void testUnavailableDataFormatOnClasspath() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").routeId("route3").unmarshal().jaxb().log("Will never get here");
                }
            });
            this.context.start();
        }, (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)e.getMessage().contains("Ensure that the data format is valid and the associated Camel component is present on the classpath"));
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

