/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.SetVariableDefinition;
import org.apache.camel.model.SetVariablesDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SetVariablesDefinitionTest
extends TestSupport {
    SetVariablesDefinitionTest() {
    }

    @Test
    void testSetFromMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        map.put("fromBody", SetVariablesDefinitionTest.body());
        map.put("isCamel", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetVariablesDefinitionTest.body().contains((Object)"Camel")));
        map.put("isHorse", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetVariablesDefinitionTest.body().contains((Object)"Horse")));
        SetVariablesDefinition def = new SetVariablesDefinition(new Object[]{map});
        Assertions.assertNotNull((Object)def.getVariables());
        Assertions.assertEquals((int)3, (int)def.getVariables().size());
        Assertions.assertEquals((Object)"isCamel", (Object)((SetVariableDefinition)def.getVariables().get(1)).getName());
    }

    @Test
    void testSetFromMapOf() {
        SetVariablesDefinition def = new SetVariablesDefinition(new Object[]{Map.of("fromBody", SetVariablesDefinitionTest.body(), "isCamel", SetVariablesDefinitionTest.body().contains((Object)"Camel"), "isHorse", SetVariablesDefinitionTest.body().contains((Object)"Horse"))});
        Assertions.assertNotNull((Object)def.getVariables());
        Assertions.assertEquals((int)3, (int)def.getVariables().size());
        HashSet<String> names = new HashSet<String>();
        for (SetVariableDefinition varDef : def.getVariables()) {
            names.add(varDef.getName());
        }
        Assertions.assertEquals(names, Set.of("fromBody", "isCamel", "isHorse"));
    }

    @Test
    void testSetFromVarargs() {
        SetVariablesDefinition def = new SetVariablesDefinition(new Object[]{"fromBody", SetVariablesDefinitionTest.body(), "isCamel", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetVariablesDefinitionTest.body().contains((Object)"Camel")), "isHorse", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetVariablesDefinitionTest.body().contains((Object)"Camel"))});
        Assertions.assertNotNull((Object)def.getVariables());
        Assertions.assertEquals((int)3, (int)def.getVariables().size());
        Assertions.assertEquals((Object)"isCamel", (Object)((SetVariableDefinition)def.getVariables().get(1)).getName());
    }

    @Test
    void testSetFromOnePair() {
        SetVariablesDefinition def = new SetVariablesDefinition(new Object[]{"fromBody", SetVariablesDefinitionTest.body()});
        Assertions.assertNotNull((Object)def.getVariables());
        Assertions.assertEquals((int)1, (int)def.getVariables().size());
        Assertions.assertEquals((Object)"fromBody", (Object)((SetVariableDefinition)def.getVariables().get(0)).getName());
    }
}

