/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetHeadersDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SetHeadersDefinitionTest
extends TestSupport {
    SetHeadersDefinitionTest() {
    }

    @Test
    void testSetFromMap() {
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>(3);
        headerMap.put("fromBody", SetHeadersDefinitionTest.body());
        headerMap.put("isCamel", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetHeadersDefinitionTest.body().contains((Object)"Camel")));
        headerMap.put("isHorse", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetHeadersDefinitionTest.body().contains((Object)"Horse")));
        SetHeadersDefinition setHeadersDef = new SetHeadersDefinition(new Object[]{headerMap});
        Assertions.assertNotNull((Object)setHeadersDef.getHeaders());
        Assertions.assertEquals((int)3, (int)setHeadersDef.getHeaders().size());
        Assertions.assertEquals((Object)"isCamel", (Object)((SetHeaderDefinition)setHeadersDef.getHeaders().get(1)).getName());
    }

    @Test
    void testSetFromMapOf() {
        SetHeadersDefinition setHeadersDef = new SetHeadersDefinition(new Object[]{Map.of("fromBody", SetHeadersDefinitionTest.body(), "isCamel", SetHeadersDefinitionTest.body().contains((Object)"Camel"), "isHorse", SetHeadersDefinitionTest.body().contains((Object)"Horse"))});
        Assertions.assertNotNull((Object)setHeadersDef.getHeaders());
        Assertions.assertEquals((int)3, (int)setHeadersDef.getHeaders().size());
        HashSet<String> names = new HashSet<String>();
        for (SetHeaderDefinition setHdrDef : setHeadersDef.getHeaders()) {
            names.add(setHdrDef.getName());
        }
        Assertions.assertEquals(names, Set.of("fromBody", "isCamel", "isHorse"));
    }

    @Test
    void testSetFromVarargs() {
        SetHeadersDefinition setHeadersDef = new SetHeadersDefinition(new Object[]{"fromBody", SetHeadersDefinitionTest.body(), "isCamel", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetHeadersDefinitionTest.body().contains((Object)"Camel")), "isHorse", ExpressionNodeHelper.toExpressionDefinition((Predicate)SetHeadersDefinitionTest.body().contains((Object)"Camel"))});
        Assertions.assertNotNull((Object)setHeadersDef.getHeaders());
        Assertions.assertEquals((int)3, (int)setHeadersDef.getHeaders().size());
        Assertions.assertEquals((Object)"isCamel", (Object)((SetHeaderDefinition)setHeadersDef.getHeaders().get(1)).getName());
    }

    @Test
    void testSetFromOnePair() {
        SetHeadersDefinition setHeadersDef = new SetHeadersDefinition(new Object[]{"fromBody", SetHeadersDefinitionTest.body()});
        Assertions.assertNotNull((Object)setHeadersDef.getHeaders());
        Assertions.assertEquals((int)1, (int)setHeadersDef.getHeaders().size());
        Assertions.assertEquals((Object)"fromBody", (Object)((SetHeaderDefinition)setHeadersDef.getHeaders().get(0)).getName());
    }
}

