/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.junit.jupiter.api.Test;

public class RoutesConfigurationUpdateTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRoutesConfigurationUpdate() throws Exception {
        this.context.start();
        RouteConfigurationBuilder rcb = new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("myConfig").onException(Exception.class).handled(true).to("mock:error");
            }
        };
        rcb.addRouteConfigurationsToCamelContext((CamelContext)this.context);
        RouteBuilder rb = new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("start").routeConfigurationId("myConfig").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeId("start2").routeConfigurationId("myConfig").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        };
        rb.addRoutesToCamelContext((CamelContext)this.context);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:error2").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().removeAllRoutes();
        RouteConfigurationBuilder rcb2 = new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("myConfig").onException(Exception.class).handled(true).to("mock:error2");
            }
        };
        rcb2.updateRouteConfigurationsToCamelContext((CamelContext)this.context);
        RouteBuilder rb2 = new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("start").routeConfigurationId("myConfig").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeId("start2").routeConfigurationId("myConfig").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        };
        rb2.updateRoutesToCamelContext((CamelContext)this.context);
        this.resetMocks();
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:error2").expectedBodiesReceived(new Object[]{"Hello World2", "Bye World2"});
        this.template.sendBody("direct:start", (Object)"Hello World2");
        this.template.sendBody("direct:start2", (Object)"Bye World2");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutesConfigurationGlobalUpdate() throws Exception {
        this.context.start();
        RouteConfigurationBuilder rcb = new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onException(Exception.class).handled(true).to("mock:error");
            }
        };
        rcb.addRouteConfigurationsToCamelContext((CamelContext)this.context);
        RouteBuilder rb = new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeId("start2").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        };
        rb.addRoutesToCamelContext((CamelContext)this.context);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:error2").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().removeAllRoutes();
        RouteConfigurationBuilder rcb2 = new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onException(Exception.class).handled(true).to("mock:error2");
            }
        };
        rcb2.updateRouteConfigurationsToCamelContext((CamelContext)this.context);
        RouteBuilder rb2 = new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeId("start2").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        };
        rb2.updateRoutesToCamelContext((CamelContext)this.context);
        this.resetMocks();
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:error2").expectedBodiesReceived(new Object[]{"Hello World2", "Bye World2"});
        this.template.sendBody("direct:start", (Object)"Hello World2");
        this.template.sendBody("direct:start2", (Object)"Bye World2");
        this.assertMockEndpointsSatisfied();
    }
}

