/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.junit.jupiter.api.Test;

public class RoutesConfigurationOnCompletionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testGlobal() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onCompletion().to("mock:global");
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
                this.from("direct:start2").to("mock:result2");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:global").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLocalConfiguration() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("mylocal").onCompletion().to("mock:local");
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
                this.from("direct:start2").routeConfigurationId("mylocal").to("mock:result2");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:global").expectedMessageCount(0);
        this.getMockEndpoint("mock:local").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testGlobalAndLocal() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onCompletion().to("mock:global");
                this.routeConfiguration("mylocal").onCompletion().to("mock:local");
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
                this.from("direct:start2").routeConfigurationId("mylocal").to("mock:result2");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:global").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:local").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

