/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutesConfigurationErrorHandlerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testGlobal() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLocalOverride() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error2")).throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:error2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLocalConfiguration() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("mylocal").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeConfigurationId("mylocal").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Bye World"});
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw exception");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testGlobalAndLocal() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                this.routeConfiguration("mylocal").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error2"));
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
                this.from("direct:start2").routeConfigurationId("mylocal").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:error2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

